
///
/// CASE LEVEL ANALYSIS
///

clear

log using 10_CaseLevel.smcl, replace
run AttyFee2007Definitions.do

reg  lnfeeexpapp lnassets lnroles lndaysin yearconfirmed saleall lnemployees shop  [pw=feeappwt], vce(robust)

/// Table 10.5 Application amount
reg lnfeeexpapp lnassets prepack preneg shop [pw=feeappwt], vce(robust)
outreg2 using Table10_5.rtf, replace ///
	label ctitle("FeeExpApp","(log)") alpha(0.001, 0.01, 0.05) adjr2 bdec(3) rdec(2) /// 
	title("Table 10.5","Determinants of Aggregate Fee and Expense Applications,","Case Level")  
outreg2, append: reg lnfeeexpapp lnassets lnroles lndaysin shop [pw=feeappwt], vce(robust)
outreg2, append:  reg lnfeeexpapp lnassets lnroles lndaysin shop lnemployees yearconfirmed saleall willkie feecom equity [pw=feeappwt], vce(robust)  

predict resid, resid
label var resid "FeeExpAppResiduals"
/// Table 10.6 Determinants of Fee and Expense Cuts, Case Level
reg lnfeeexp0cut DE equity lnemployees manufacturing  [pw=feeappwt], vce(robust)
outreg2 using Table10_6.rtf, replace /// 
	label ctitle("FeeExpCut","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) /// 
	title("Table 10.6","Determinants of Fee and Expense Cuts,","Case Level")  
outreg2, append: reg lnfeeexp0cut DE equity manufacturing  lnfeeexpapp [pw=feeappwt], vce(robust)
outreg2, append: reg lnfeeexp0cut DE equity manufacturing  lnfeeexpapp emerge1 willkie [pw=feeappwt], vce(robust)
outreg2, append: reg lnfeeexp0cut DE equity manufacturing  lnfeeexpapp emerge1 willkie resid  [pw=feeappwt], vce(robust)

log close

///	
///  APPLICATION LEVEL ANALYSIS
///


log using 10_AppLevel.smcl, replace
run FeeAppDefinitions.do

/// Table 10.4a
tab gotcut DE, chi

///Table 10.4.b
oneway  feexpzcutpct denyot if denyot!="OT", tab
oneway  feexpzcutpct denyot if denyot!="DE", tab
oneway  feexpzcutpct denyot if denyot!="NY", tab
oneway  feexpzcutpct OT, tab

oneway lnexperience denyot, tab

/// Table 10.7 Fee and Expense Application, Application Level
reg lnfeeexpapp prepack preneg lnassets leaddipbkatty shop dipleadfinad leadccatty fa dip lnexperience, robust cluster(conameshort)
outreg2 using Table10_7.rtf, replace ///
	label ctitle("FeeExpApp","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2)  ///
	title("Table 10.7","Determinants of Aggregate Fee and Expense Applications,","Application Level") 
outreg2, append: reg lnfeeexpapp lnnumobj leaddipbkatty dipleadfinad leadccatty lnassets lndaysin yearconfirmed shop fa dip, robust cluster(conameshort)
outreg2, append: reg lnfeeexpapp lnnumobj leaddipbkatty dipleadfinad leadccatty lnassets lndaysin yearconfirmed shop fa dip lnexperience, robust cluster(conameshort)

reg lnfeeexpapp lnnumobj leaddipbkatty dipleadfinad leadccatty lnassets lndaysin dateconfirmed shop fa dip lnexperience
predict resid, resid
gen feecomres = feecom*resid
gen feecomapp = lnfeeexpapp * feecom
egen lowyear = min(datefiled)

/// Table 10.8 Determinants of Fee and Expense Cuts, Application Level (table must be created manually)
hnblogit lnfeeexpzcut resid lnfeeexpapp DE yearfiled specdipatty bkatty lnnumobj , cluster(conameshort) robust
hnblogit lnfeeexpzcut resid feecom feecomapp lnfeeexpapp, cluster(conameshort) robust
hnblogit lnfeeexpzcut resid feecom feecomres lnfeeexpapp, cluster(conameshort) robust
hnblogit lnfeeexpzcut resid feecom feecomres lnfeeexpapp DE  yearfiled specdipatty  bkatty lnnumobj dipleadfinad  , cluster(conameshort) robust

log close


log using Table109.smcl, replace
run FeeAppDefinitions.do
reg lnfeeexpapp lnnumobj leaddipbkatty dipleadfinad leadccatty lnassets lndaysin dateconfirmed shop fa dip lnexperience
predict resid, resid
/// Table 10.9
oneway resid gotcut, tab
graph box resid, over(gotcut)
gen piggy = 0
replace piggy = 1 if resid > 0
tab piggy gotcut, col chi
log close

log using Table1010.smcl, replace
/// Table 10.10
/// First create scalar variables for the sum and the mean of each cell in the table
capture scalar drop _all
sum feeexpapp if gotcut==1 & piggy==0
scalar sumapplow=r(sum)
scalar meanapplow=r(mean)
scalar ncutlow=r(N)
sum feeexpzcut if gotcut==1 & piggy==0
scalar sumcutlow=r(sum)
scalar meancutlow=r(mean)
sum feeexpapp if gotcut==1 & piggy==1
scalar sumapphi=r(sum)
scalar meanapphi=r(mean)
scalar ncuthigh=r(N)
sum feeexpzcut if gotcut==1 & piggy==1
scalar sumcuthi=r(sum)
scalar meancuthi=r(mean)
sum feeexpapp if gotcut==1
scalar sumapptot=r(sum)
scalar meanapptot=r(mean)
scalar ncuttot=r(N)
sum feeexpzcut if gotcut==1
scalar sumcuttot=r(sum)
scalar meancuttot=r(mean)

/// Display the scalars
di "Low Fee App Total  " %-12.0fc sumapplow 
di "Low Fee App Mean  " %-12.0fc meanapplow
di "Low Fee Cut Total  " %-12.0fc sumcutlow
di "Low Fee Cut Mean  " %-12.0fc meancutlow
di "High Fee App Total  " %-12.0fc sumapphi 
di "High Fee App Mean  " %-12.0fc meanapphi
di "High Fee Cut Total  " %-12.0fc sumcuthi
di "High Fee Cut Mean  " %-12.0fc meancuthi
di "Fee App Total  " %-12.0fc sumapptot
di "Fee App Mean  " %-12.0fc meanapptot
di "Fee Cut Total  " %-12.0fc sumcuttot
di "Fee Cut Mean  " %-12.0fc meancuttot

/// Compute the percentages using the scalars
di "Number of Low Cases as Pct of Total Cases  " %-5.3f ncutlow/ncuttot
di "Low Cut as Pct of Amt Sought  " %-5.3f sumcutlow/sumapplow
di "High Cut as Pct of Amt Sought  " %-5.3f sumcuthi/sumapphi
di "Total Cut as Pct of Amt Sought  " %-5.3f sumcuttot/sumapptot
di "Number of Low Cases as Pct of Total  " %-5.3f ncutlow/ncuttot
di "Low Fee App Total as Pct of Total App  " %-5.3f sumapplow/sumapptot
di "Low Fee App Mean as Pct of Total Mean  " %-5.3f meanapplow/meanapptot
di "Low Fee Cut Total as Pct of Total Cut  " %-5.3f sumcutlow/sumcuttot
di "Low Fee Cut Mean as Pct of Total Mean  " %-5.3f meancutlow/meancuttot

/// Compute the significance tests of the average amounts cut in Low and High
/// These figures go into the 5th column of Table 10.10, in the second row of each cell.
oneway feexpzcutpct piggy if gotcut==1, tab

log close
